% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp.R
\name{rf_vimp}
\alias{rf_vimp}
\title{Estimate a Single Variable Importance Metric for \code{cjbart} Object}
\usage{
rf_vimp(model, outcome, covars = NULL)
}
\arguments{
\item{model}{Object of class \code{cjbart}, the result of running \code{\link[=IMCE]{IMCE()}}}

\item{outcome}{Character string detailing the covariate over which to analyze heterogeneous effects}

\item{covars}{An optional vector of covariates to include in the importance metric check. When \code{covars = NULL} (the default), all covariates are included in the importance model.}
}
\value{
Data.frame of variable importance scores for each covariate in the model, as well as values for the estimated 95\% confidence interval for each importance score.
}
\description{
Estimates random forest variable importance scores for a single attribute-level of a conjoint experiment. This function is for advanced use. Users should typically use the \code{\link[=het_vimp]{het_vimp()}} function.
}
