% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_put_files_csv_archive}
\alias{imports_put_files_csv_archive}
\title{Update the archive status of this object}
\usage{
imports_put_files_csv_archive(id, status)
}
\arguments{
\item{id}{integer required. The ID of the object.}

\item{status}{boolean required. The desired archived status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the import.}
\item{name}{string, The name of the import.}
\item{source}{list, A list containing the following elements: 
\itemize{
\item fileIds array, The file ID(s) to import, if importing Civis file(s).
\item storagePaths object, 
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item schema string, The destination schema name.
\item table string, The destination table name.
\item remoteHostId integer, The ID of the destination database host.
\item credentialId integer, The ID of the credentials for the destination database.
\item primaryKeys array, A list of the primary key column(s) of the destination table.If the destination table does not exist, and the import mode is "upsert", this field is required.
\item lastModifiedKeys array, A list of the columns indicating a record has been updated.If the destination table does not exist, and the import mode is "upsert", this field is required.
}}
\item{firstRowIsHeader}{boolean, A boolean value indicating whether or not the first row of the source file is a header row.}
\item{columnDelimiter}{string, The column delimiter for the file. Valid arguments are "comma", "tab", and "pipe". Defaults to "comma".}
\item{escaped}{boolean, A boolean value indicating whether or not the source file has quotes escaped with a backslash.Defaults to false.}
\item{compression}{string, The type of compression of the source file. Valid arguments are "gzip" and "none". Defaults to "none".}
\item{existingTableRows}{string, The behavior if a destination table with the requested name already exists.  One of "fail", "truncate", "append", "drop", or "upsert".Defaults to "fail".}
\item{maxErrors}{integer, The maximum number of rows with errors to ignore before failing. This option is not supported for Postgres databases.}
\item{tableColumns}{array, An array containing the following fields: 
\itemize{
\item name string, The column name.
\item sqlType string, The SQL type of the column.
}}
\item{loosenTypes}{boolean, If true, SQL types with precisions/lengths will have these values increased to accomodate data growth in future loads. Type loosening only occurs on table creation. Defaults to false.}
\item{execution}{string, In upsert mode, controls the movement of data in upsert mode. If set to "delayed", the data will be moved after a brief delay. If set to "immediate", the data will be moved immediately. In non-upsert modes, controls the speed at which detailed column stats appear in the data catalogue. Defaults to "delayed", to accomodate concurrent upserts to the same table and speedier non-upsert imports.}
\item{redshiftDestinationOptions}{list, A list containing the following elements: 
\itemize{
\item diststyle string, The diststyle to use for the table. One of "even", "all", or "key".
\item distkey string, Distkey for this table in Redshift
\item sortkeys array, Sortkeys for this table in Redshift. Please provide a maximum of two.
}}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Update the archive status of this object
}
