% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.blackbox.R
\name{ciu.blackbox.new}
\alias{ciu.blackbox.new}
\title{Create CIU.BlackBox object}
\usage{
ciu.blackbox.new()
}
\value{
Object of class \code{CIU.BlackBox}.
}
\description{
This method mainly serves as an "interface specification" for objects of
class \code{CIU.BlackBox}, i.e. it defines what method(s) have to be implemented
by any object of class \code{CIU.BlackBox}. A \code{CIU.BlackBox} object
is actually a \code{\link{list}}.
}
\details{
An alternative and simpler (but less flexible) way to do the same is to
use the \code{predict.function} parameter of \code{\link{ciu.new}}, where
\code{predict.function <- function(model, inputs) {predict(model,inputs,n.trees=10000)}}
would accomplish the same as for the Example below. An example using this
approach is also included in Examples.

The advantage of using a \code{CIU.BlackBox} wrapper
(rather than the simplee \code{predict.function} approach) is that it is
possible to keep object variables or maintain whatever state
information might be needed between calls.

The only things that are actually required from a
\code{CIU.BlackBox} object is:
\enumerate{
\item That it is a \code{\link{list}} with an element called \code{eval}.
\item That the value of \code{eval} element is a function of the form \verb{eval = function(inputs)}
\item That it inherits the class \code{CIU.BlackBox}.
}
}
\examples{
# Create CIU.BlackBox wrapper for Gradient Boosting
library(MASS) # Just in case Boston is not already available
library(gbm)
gbm.ciu.bb <- function(gbm, n.trees=1) {
  o.gbm <- gbm
  o.n.trees <- n.trees
  pub <- list(eval = function(inputs) { predict(o.gbm,inputs,n.trees=o.n.trees) })
  class(pub) <- c("CIU.BlackBox",class(pub))
  return(pub)
}
\donttest{
# Train and explain. We don't care about training/test sets here.
gbm.Boston <- gbm(medv ~ . ,data = Boston, distribution = "gaussian",
n.trees=10000, shrinkage = 0.01, interaction.depth = 4)
gbm.ciu <- gbm.ciu.bb(gbm.Boston, 10000)
ciu <- ciu.new(gbm.ciu, medv~., Boston)
ciu$barplot.ciu(Boston[370,1:13], sort = "CI")

# Same but using `predict.function` parameter in `ciu.new`.
# Using `ggplot.col.ciu` here for a change.
predict.function <- function(model, inputs) {predict(model,inputs,n.trees=10000)}
ciu <- ciu.new(gbm.Boston, medv~., Boston, predict.function=predict.function)
ciu$ggplot.col.ciu(Boston[370,1:13], sort = "CI")
}
}
\author{
Kary Främling
}
