% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDP.R
\name{PDP}
\alias{PDP}
\alias{PDP.citodnn}
\alias{PDP.citodnnBootstrap}
\title{Partial Dependence Plot (PDP)}
\usage{
PDP(
  model,
  variable = NULL,
  data = NULL,
  ice = FALSE,
  resolution.ice = 20,
  plot = TRUE,
  parallel = FALSE,
  ...
)

\method{PDP}{citodnn}(
  model,
  variable = NULL,
  data = NULL,
  ice = FALSE,
  resolution.ice = 20,
  plot = TRUE,
  parallel = FALSE,
  ...
)

\method{PDP}{citodnnBootstrap}(
  model,
  variable = NULL,
  data = NULL,
  ice = FALSE,
  resolution.ice = 20,
  plot = TRUE,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{model}{a model created by \code{\link{dnn}}}

\item{variable}{variable as string for which the PDP should be done. If none is supplied it is done for all variables.}

\item{data}{specify new data PDP should be performed . If NULL, PDP is performed on the training data.}

\item{ice}{Individual Conditional Dependence will be shown if TRUE}

\item{resolution.ice}{resolution in which ice will be computed}

\item{plot}{plot PDP or not}

\item{parallel}{parallelize over bootstrap models or not}

\item{...}{arguments passed to \code{\link{predict}}}
}
\value{
A list of plots made with 'ggplot2' consisting of an individual plot for each defined variable.
}
\description{
Calculates the Partial Dependency Plot for one feature, either numeric or categorical. Returns it as a plot.
}
\section{Description}{
Performs a Partial Dependency Plot (PDP) estimation to analyze the relationship between a selected feature and the target variable.

The PDP function estimates the partial function \eqn{\hat{f}_S}{}:

\eqn{\hat{f}_S(x_S)=\frac{1}{n}\sum_{i=1}^n\hat{f}(x_S,x^{(i)}_{C})}{}

with a Monte Carlo Estimation:

\eqn{\hat{f}_S(x_S)=\frac{1}{n}\sum_{i=1}^n\hat{f}(x_S,x^{(i)}_{C})}{}
using a Monte Carlo estimation method. It calculates the average prediction of the target variable for different values of the selected feature while keeping other features constant.

For categorical features, all data instances are used, and each instance is set to one level of the categorical feature. The average prediction per category is then calculated and visualized in a bar plot.

If the \code{ice} parameter is set to \code{TRUE}, the Individual Conditional Expectation (ICE) curves are also shown. These curves illustrate how each individual data sample reacts to changes in the feature value. Please note that this option is not available for categorical features. Unlike PDP, the ICE curves are computed using a value grid instead of utilizing every value of every data entry.

Note: The PDP analysis provides valuable insights into the relationship between a specific feature and the target variable, helping to understand the feature's impact on the model's predictions.
If a categorical feature is analyzed, all data instances are used and set to each level.
Then an average is calculated per category and put out in a bar plot.

If ice is set to true additional the individual conditional dependence will be shown and the original PDP will be colored yellow.
These lines show, how each individual data sample reacts to changes in the feature. This option is not available for categorical features.
Unlike PDP the ICE curves are computed with a value grid instead of utilizing every value of every data entry.
}

\examples{
\donttest{
if(torch::torch_is_installed()){
library(cito)

# Build and train  Network
nn.fit<- dnn(Sepal.Length~., data = datasets::iris)

PDP(nn.fit, variable = "Petal.Length")
}
}
}
\seealso{
\code{\link{ALE}}
}
