% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_visualization.R
\name{ssm_plot_contrast}
\alias{ssm_plot_contrast}
\title{Create a Difference Plot of SSM Contrast Results}
\usage{
ssm_plot_contrast(
  .ssm_object,
  axislabel = "Difference",
  xy = TRUE,
  color = "red",
  linesize = 1.25,
  fontsize = 12
)
}
\arguments{
\item{.ssm_object}{Required. The results output of \code{ssm_analyze}.}

\item{axislabel}{Optional. A string to label the y-axis (default =
"Difference").}

\item{xy}{A logical determining whether the X-Value and Y-Value parameters
should be included in the plot (default = TRUE).}

\item{color}{Optional. A string corresponding to the color of the point range
(default = "red").}

\item{linesize}{Optional. A positive number corresponding to the size of the
point range elements in mm (default = 1.5).}

\item{fontsize}{Optional. A positive number corresponding to the size of the
axis labels, numbers, and facet headings in pt (default = 12).}
}
\value{
A ggplot variable containing difference point-ranges faceted by SSM
parameter. An interval that does not contain the value of zero has p<.05.
}
\description{
Take in the results of a Structural Summary Method analysis with pairwise
contrasts and plot the point and interval estimates for each parameter's
contrast (e.g., between groups or measures).
}
