% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidying_functions.R
\name{standardize}
\alias{standardize}
\title{Standardize circumplex scales using normative data}
\usage{
standardize(.data, scales, angles, instrument, sample = 1, prefix = "",
  suffix = "_z")
}
\arguments{
\item{.data}{Required. A data frame containing at least circumplex scales.}

\item{scales}{Required. The variable names or column numbers for the
variables in \code{.data} that contain circumplex scales to be
standardized.}

\item{angles}{Required. A numeric vector containing the angular displacement
of each circumplex scale included in \code{scales} (in degrees).}

\item{instrument}{Required. An instrument object from the package. To see
the available circumplex instruments, see \code{instruments()}.}

\item{sample}{Required. An integer corresponding to the normative sample
to use in standardizing the scale scores (default = 1). See \code{?norms}
to see the normative samples available for an instrument.}

\item{prefix}{Optional. A string to include at the beginning of the newly
calculated scale variables' names, before the scale name and \code{suffix}
(default = "").}

\item{suffix}{Optional. A string to include at the end of the newly
calculated scale variables' names, after the scale name and \code{prefix}
(default = "_z").}
}
\value{
A data frame that matches \code{.data} except that new variables are
appended that contain standardized versions of \code{scales}. These new
variables will have the same name as \code{scales} but with a "_z" suffix.
}
\description{
Take in a data frame containing circumplex scales, angle definitions for each
scale, and normative data (from the package or custom) and return that same
data frame with each specified circumplex scale transformed into standard
scores (i.e., z-scores) based on comparison to the normative data.
}
\examples{
data("jz2017")
instrument("iipsc")
standardize(jz2017, PA:NO, octants(), instrument = iipsc, sample = 1)
}
\seealso{
Other tidying functions: \code{\link{ipsatize}},
  \code{\link{score}}
}
\concept{tidying functions}
