% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolarPlotRL.R
\name{PolarPlotRL}
\alias{PolarPlotRL}
\title{Polar plot of T-year levels}
\usage{
PolarPlotRL(
  RLBootList,
  Data,
  drc,
  thetaGrid = 1:360,
  TTs,
  whichPlot,
  alpha = 0.05,
  ylim = NULL,
  pointSize = 4,
  fontSize = 12,
  lineWidth = 4
)
}
\arguments{
\item{RLBootList}{List containing bootstrap estimates of T-year levels}

\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{thetaGrid}{Grid values at which the estimation is performed}

\item{TTs}{T-year levels. For example, TTs = c(100, 10000).}

\item{whichPlot}{Index identifying which T-year level should be plotted from
TTs. If TTs = c(100, 10000), then whichPlot=2 produces a plot for the
10000-year level}

\item{alpha}{Significance level for the confidence intervals. Default to 0.05.}

\item{ylim}{Range for the y-axis}

\item{pointSize}{Size of points (observations)}

\item{fontSize}{Font size}

\item{lineWidth}{Threshold width}
}
\value{
Polar plot of T-year levels.
}
\description{
Polar plot of T-year levels
}
\examples{
## See also examples in vignettes:
# vignette("localMethods", package = "circularEV")
# vignette("splineML", package = "circularEV")
}
\seealso{
\code{\link{SplineML}} and \code{\link{LocalEstim}} for examples.
}
