% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccGenomicPoints}
\alias{ccGenomicPoints}
\title{Add points for genomic data visualization}
\usage{
ccGenomicPoints(
  region = NULL,
  value = NULL,
  numeric.column = NULL,
  posTransform = NULL,
  pch = par("pch"),
  col = par("col"),
  cex = par("cex"),
  bg = par("bg"),
  ...
)
}
\arguments{
\item{region}{A data frame contains 2 columns which correspond to start positions and end positions.
}

\item{value}{A data frame contains values and other information.
}

\item{numeric.column}{Which column in \code{value} data frame should be taken as y-value.
 If it is not defined, the whole numeric columns in \code{value} will be taken.
}

\item{posTransform}{Self-defined function to transform genomic positions, see \code{\link[circlize]{posTransform.default}} for explanation
}

\item{pch}{Type of points. Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.points}}.
}

\item{col}{Color of points. If there is only one numeric column, the length of \code{col} can be either one or number of rows of \code{region}.
 If there are more than one numeric column, the length of \code{col} can be either one or number of numeric columns.
 Pass to \code{\link[circlize]{circos.points}}.
}

\item{cex}{Size of points. Settings are similar as \code{col}. Pass to \code{\link[circlize]{circos.points}}.
}

\item{bg}{Background colors for points.
}

\item{...}{Mysterious parameters.
}
}
\value{
Object \linkS4class{ccGenomicCellGeom}
}
\description{
Object \linkS4class{ccGenomicCellGeom} will call the function \link[circlize:circos.genomicPoints]{circlize::circos.genomicPoints} while drawing.
}
\examples{
library(circlizePlus)
data <- generateRandomBed(nr = 30, nc = 2)
all_chr <- c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8",
"chr9", "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16",
"chr17", "chr18", "chr19", "chr20", "chr21", "chr22", "chrX", "chrY")
cc <- ccPlot(initMode = "initializeWithIdeogram", plotType = NULL)
t1 <- ccGenomicTrack(data = data, numeric.column = 4)
cells1 <- ccCells(sector.indexes = all_chr) +
ccGenomicPoints(region = \(region, value){
  region
}, value = \(region, value){
  value
}, numeric.column = 2)
t1 <- t1 + cells1
show(cc + t1)
}
