\name{circos.heatmap}
\alias{circos.heatmap}
\title{
Make circular heatmaps
}
\description{
Make circular heatmaps
}
\usage{
circos.heatmap(mat, split = NULL, col, na.col = "grey",
    bg.border = NA, bg.lty = par("lty"), bg.lwd = par("lwd"), ignore.white = TRUE,
    cluster = TRUE, clustering.method = "complete", distance.method = "euclidean",
    dend.callback = function(dend, m, si) reorder(dend, rowMeans(m)),
    dend.side = c("none", "outside", "inside"), dend.track.height = 0.1,
    rownames.side = c("none", "outside", "inside"), rownames.cex = 0.5,
    rownames.font = par("font"), rownames.col = "black",
    show.sector.labels = FALSE, ...)
}
\arguments{

  \item{mat}{A matrix or a vector. The vector is transformed as a one-column matrix.}
  \item{split}{A categorical variable. It splits the matrix into a list of matrices.}
  \item{col}{If the values in the matrices are continuous, the color should be a color mapping generated by  \code{\link{colorRamp2}}. If the values are characters, the color should be a named color vector.}
  \item{na.col}{Color for \code{NA} values.}
  \item{bg.border}{Color for background border.}
  \item{bg.lty}{Line type of the background border.}
  \item{bg.lwd}{Line width of the background border.}
  \item{ignore.white}{Whether to draw the white color?}
  \item{cluster}{whether to apply clustering on rows.}
  \item{clustering.method}{Clustering method, pass to \code{\link[stats]{hclust}}.}
  \item{distance.method}{Distance method, pass to \code{\link[stats]{dist}}.}
  \item{dend.callback}{A callback function that is applied to the dendrogram in every sector.}
  \item{dend.side}{Side of the dendrograms relative to the heatmap track.}
  \item{dend.track.height}{Track height of the dendrograms.}
  \item{rownames.side}{Side of the row names relative to the heatmap track.}
  \item{rownames.cex}{Cex of row names.}
  \item{rownames.font}{Font of row names.}
  \item{rownames.col}{Color of row names.}
  \item{show.sector.labels}{Whether to show sector labels.}
  \item{...}{Pass to \code{\link{circos.track}} which draws the heatmap track.}

}
\seealso{
\url{https://jokergoo.github.io/2020/05/21/make-circular-heatmaps/}
}
\examples{
\donttest{
set.seed(123)
mat1 = rbind(cbind(matrix(rnorm(50*5, mean = 1), nr = 50), 
                   matrix(rnorm(50*5, mean = -1), nr = 50)),
             cbind(matrix(rnorm(50*5, mean = -1), nr = 50), 
                   matrix(rnorm(50*5, mean = 1), nr = 50))
            )
rownames(mat1) = paste0("R", 1:100)
colnames(mat1) = paste0("C", 1:10)
mat1 = mat1[sample(100, 100), ] # randomly permute rows
split = sample(letters[1:5], 100, replace = TRUE)
spilt = factor(split, levels = letters[1:5])
col_fun1 = colorRamp2(c(-2, 0, 2), c("blue", "white", "red"))
circos.heatmap(mat1, split = split, col = col_fun1)
circos.clear()
}
}
