% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circletype.R
\name{circletype}
\alias{circletype}
\title{Apply a curvature on text elements}
\usage{
circletype(ui_element, dir = 1, radius = 200)
}
\arguments{
\item{ui_element}{Text element on which the curvature should be applied. Must be something like `h1()`, `h2()`, etc. This element MUST have an id. Doesn't work on other HTML elements such as buttons.}

\item{dir}{Sets the text direction, must be equal to 1 (clockwise) or -1 (counter-clockwise).}

\item{radius}{Sets the desired text radius. The lower the value, the more curved the text.}
}
\value{
A curved text.
}
\description{
Apply a curvature on text elements
}
\examples{
if (interactive()) {
library(shiny)

ui <- fluidPage(
  use_circletype(), # load dependencies
  circletype(h1("this is a title", id = "test_h1"), dir = -1, radius = 200)
)

server <- function(input, output, session) {}

shinyApp(ui, server)
}
}
