% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builds.R
\name{builds}
\alias{builds}
\alias{get_pipelines}
\alias{get_workflows}
\alias{get_jobs}
\alias{retry_workflow}
\title{Retrieve Metadata from Circle CI Builds}
\usage{
get_pipelines(
  repo = github_info()$name,
  user = github_info()$owner$login,
  limit = 30,
  vcs_type = "gh",
  api_version = "v2"
)

get_workflows(
  pipeline_id = NULL,
  repo = github_info()$name,
  user = github_info()$owner$login
)

get_jobs(
  workflow_id = NULL,
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh"
)

retry_workflow(workflow_id = NULL)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{limit}{\verb{[integer]}\cr
How many builds should be returned? Maximum allowed by Circle is
30.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}

\item{pipeline_id}{\verb{[character]}\cr
A Circle CI pipeline ID.}

\item{workflow_id}{\verb{[character]}\cr
A Circle CI workflow ID.}
}
\value{
An object of class \code{circle_collection} containing list
information on the queried Circle CI pipelines/workflows/jobs.
}
\description{
Query information about pipelines, workflows or jobs on
Circle CI.
The S3 \code{print()} method for these functions returns the respective
pipeline IDs.
To inspect the details of each pipeline, save the return value in an object
and inspect the respective sub-lists.

If no pipeline or workflow is supplied to \code{get_workflows()}/\code{get_jobs()},
the ten most recent pipelines/jobs are queried, respectively.
}
\details{
While the \verb{get_*()} functions query information about the respective
build level details (pipeline - workflow - job), \code{retry_workflow()} let's
users rerun a specific workflow.
By default, the workflow from the most recent pipeline will be rerun if
no pipeline ID was supplied.
}
\examples{
\dontrun{
pipelines <- get_pipelines()

workflows <- get_workflows()

jobs <- get_jobs()

# rerun most recent workflow
retry_workflow()
}
}
