% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-var.R
\name{env_var}
\alias{env_var}
\alias{get_env_vars}
\alias{set_env_var}
\alias{delete_env_var}
\title{Interact with Environment Variable(s) on Circle CI}
\usage{
get_env_vars(
  name = NULL,
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v2"
)

set_env_var(
  var,
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v2",
  quiet = FALSE
)

delete_env_var(
  var,
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v2",
  quiet = FALSE
)
}
\arguments{
\item{name}{\verb{[character]}\cr
Name of a specific environment variable.
If not set, all env vars are returned.}

\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}

\item{var}{\verb{[list]}\cr
A list containing key-value pairs of environment variable and its value.}

\item{quiet}{\verb{[logical]}\cr
If \code{TRUE}, console output is suppressed.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Add, get or set Circle CI environment variable(s) for a repo on
Circle CI.
}
\examples{
\dontrun{
# get env var
get_env_vars()

# set env var
set_env_var(var = list("foo" = "123"))

# delete env var
delete_env_var("foo")
}
}
