% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{slope}
\alias{slope}
\title{Piecewise-linear local slopes given a (non-strictly) monotone x-y sequence}
\usage{
slope(
  x,
  y,
  outx = x,
  allowZero = FALSE,
  tol = 1e-04,
  full = FALSE,
  decreasing = FALSE
)
}
\arguments{
\item{x}{numeric or integer: input x values, must be strictly increasing}

\item{y}{numeric: input y values, must be monotone (can be non-strict) and in line with the direction specified by \code{decreasing}}

\item{outx}{numeric or integer: x values at which slopes are desired (default: same as input values)}

\item{allowZero}{logical: should zero be allowed in the output? Default \code{FALSE}}

\item{tol}{tolerance level: when \code{allowZero=FALSE}, slope below that value is considered zero. Default 1e-4. Might need to change if you use unusual units for x or y.}

\item{full}{logical: should a more detailed output be provided? Default \code{FALSE} (see details under 'Value').}

\item{decreasing}{logical: is input supposed to be monotone decreasing rather than increasing? Default \code{FALSE}}
}
\value{
If \code{full=FALSE}, returns a vector of slopes at the points specified by \code{outx}.

If \code{full=TRUE}, returns a list with slopes at the design point (\code{rawslopes}), the initial guess at output slopes (\code{initial}), and the official final ones (\code{final}).
}
\description{
Estimate monotone piecewise-linear slopes, with the default behavior forbidding zero slope. This behavior is due to the fact that the function is used to invert confidence intervals using the Delta method. The input interval has to be strictly increasing in \code{x}, and (non-strictly) monotone in \code{y} (increasing or decreasing).
}
\details{
At design points (i.e., the input \code{x} values), the function takes the average between the left and right slopes (on the edges the inside slope is technically replicated to the outside). If \code{allowZero=FALSE} (default), the algorithm gradually expands the x range over which slope is observed (by increments of one average \code{x} spacing), until a positive slope results. If the input is completely flat in \code{y} and \code{allowZero=FALSE}, the function returns \code{NA}s.
}
\seealso{
\code{\link{deltaInverse}}, which uses this function.
}
