% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_cifti.R
\name{info_cifti}
\alias{info_cifti}
\alias{infoCIfTI}
\alias{infocii}
\title{Get CIFTI metadata}
\usage{
info_cifti(cifti_fname)

infoCIfTI(cifti_fname)

infocii(cifti_fname)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}
}
\value{
The metadata component of a \code{"xifti"} for the input CIFTI file
}
\description{
Get CIFTI metadata from the NIFTI header and XML using the Connectome
Workbench command \code{-nifti-information}. The information is formatted as
the \code{meta} component in a \code{"xifti"} object
(see \code{\link{template_xifti}}), and includes:
\enumerate{
\item medial wall masks for the left and right cortex
\item the subcortical labels (ordered spatially)
\item the subcortical mask
\item other NIFTI intent-specific metadata
}
}
\details{
Additional metadata depends on the type of CIFTI file:

\enumerate{
\item{"dtseries"}{
\enumerate{
\item{time_start:}{   Start time}
\item{time_step:}{   The TR}
\item{time_unit:}{   Unit of time}
}
}
\item{"dscalar"}{
\enumerate{
\item{names:}{   Name of each data column}
}
}
\item{"dlabels"}{
\enumerate{
\item{names:}{(   Names of each data column.)}
\item{labels:}{(   List of \eqn{L x 5} data.frames. Row names are the label names. Column names are Key, Red, Green, Blue, and Alpha. List entry names are the names of each data column.)}
}
}
}
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-nifti-information"} Workbench command.
}

\section{Label Levels}{

\code{xifti$meta$subcort$labels} is a factor with the following levels:

\enumerate{
\item{Cortex-L}
\item{Cortex-R}
\item{Accumbens-L}
\item{Accumbens-R}
\item{Amygdala-L}
\item{Amygdala-R}
\item{Brain Stem}
\item{Caudate-L}
\item{Caudate-R}
\item{Cerebellum-L}
\item{Cerebellum-R}
\item{Diencephalon-L}
\item{Diencephalon-R}
\item{Hippocampus-L}
\item{Hippocampus-R}
\item{Pallidum-L}
\item{Pallidum-R}
\item{Putamen-L}
\item{Putamen-R}
\item{Thalamus-L}
\item{Thalamus-R}
}

These correspond to the same structures as given by
\code{ft_read_cifti} in the \code{cifti-matlab} MATLAB toolbox. Note that
the first two levels (left and right cortex) are not used.
}

\seealso{
Other functions for reading in CIFTI or GIFTI data: 
\code{\link{as.xifti}()},
\code{\link{load_parc}()},
\code{\link{load_surf}()},
\code{\link{read_cifti}()},
\code{\link{read_surf}()},
\code{\link{read_xifti2}()}
}
\concept{reading}
