% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{configure}
\alias{configure}
\title{Function to configure the behavior of the chronosphere package.}
\usage{
configure(timeout = NULL, remote = NULL, curl = NULL)
}
\arguments{
\item{timeout}{Timeout option used with default R download socket. The global default value for this is 500, which can be increased for very large files and a slow internet connection. Has no effect, when \code{curl=TRUE}.}

\item{remote}{Character string which is the URL of the chronos server.}

\item{curl}{Logical value of the 'curl' package variable.}
}
\value{
The function has no return value.
}
\description{
This function will allow you to set package variables.
}
\details{
The following package-wide variables can be set.
\code{timeout}: Positive integer. Timeout of connections in seconds when the default R sockets are used. The global setting by default is `300`. 
#' \code{remote}: Character string. URL of the chronosphere repositories, the default value is \code{"https://github.com/chronosphere-portal/chrono_arch/raw/main/"}.
\code{curl}: Logical value. If set to \code{TRUE} (default), the curl libraries are used to download files. If set to \code{FALSE} (default) the default R sockets are used, which can result in timeout issues that need to be resolved manually.
}
\examples{
configure(curl=FALSE)
}
