% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruction.R
\name{reconstruct}
\alias{reconstruct}
\alias{reconstruct,matrix-method}
\alias{reconstruct,data.frame-method}
\alias{reconstruct,numeric-method}
\alias{reconstruct,character-method}
\alias{reconstruct,SpatialPolygonsDataFrame-method}
\title{Reconstruct geographic features}
\usage{
reconstruct(x, ...)

\S4method{reconstruct}{matrix}(
  x,
  age,
  model = "PALEOMAP",
  listout = TRUE,
  verbose = FALSE,
  enumerate = TRUE,
  chunk = 200,
  reverse = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE
)

\S4method{reconstruct}{data.frame}(x, ...)

\S4method{reconstruct}{numeric}(x, ...)

\S4method{reconstruct}{character}(
  x,
  age,
  model = "PALEOMAP",
  listout = TRUE,
  verbose = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE
)

\S4method{reconstruct}{SpatialPolygonsDataFrame}(
  x,
  age,
  model = "PALEOMAP",
  listout = TRUE,
  verbose = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE
)
}
\arguments{
\item{x}{are the features to be reconstructed. Can be a vector with longitude and latitude representing
a single point or a matrix/dataframe with the first column as longitude and second column as latitude, or a \code{SpatialPolygonsDataFrame} class object. 
The character strings \code{"plates"} and \code{"coastlines"} return static plates and rotated present-day coastlines, respectively.}

\item{...}{arguments passed to class-specific methods.}

\item{age}{(\code{numeric})is the age in Ma at which the points will be reconstructed}

\item{model}{(\code{character} or \code{\link{platemodel}}) The  reconstruction model. The class of this argument selects the submodule used for reconstruction, a \code{character} value will invoke the remote reconstruction submodule and will submit \code{x} to the GPlates Web Service. A \code{platemodel} class object will call the local-reconstruction submodule. The default is \code{"PALEOMAP"}. See details for available models.}

\item{listout}{(\code{logical})If multiple ages are given, the output can be returned as a \code{list} if \code{listout = TRUE}.}

\item{verbose}{(\code{logical}) Should call URLs (remote submodule) or console feedback (local-submodule) be printed?}

\item{enumerate}{(\code{logical}) Should be all coordinate/age combinations be enumerated and reconstructed (set to \code{TRUE} by default)? \code{FALSE} is applicable only if the number of rows in \code{x} is equal to the number elementes in \code{age}. Then a point will be reconstructed to the age that has the same index in \code{age} as the row of the coordinates in \code{x}. List output is not available in this case.}

\item{chunk}{(\code{numeric}) Argument of the remote reconstruction submodule. Single integer, the number of coordinates that will be queried from the GPlates in a single go.}

\item{reverse}{(\code{logical}) Argument of the remote reconstruction submodule. The flag to control the direction of reconstruction. If \code{reverse = TRUE}, the function will 
calculate the present-day coordinates of the given paleo-coordinates.}

\item{path.gplates}{(\code{character}) Argument of the local reconstruction submodule. In case the GPlates executable file is not found at the coded default location, the full path to the executable (gplates-<ver>.exe on Windows) can be entered here.}

\item{cleanup}{(\code{logical}) Argument of the local reconstruction submodule. Should the temporary files be deleted immediately after reconstructions?}

\item{dir}{(\code{character}) Argument of the local reconstruction submodule. Directory where the temporary files of the reconstruction are stored (defaults to a temporary directory created by R). Remember to toggle \code{cleanup} if you want to see the files.}

\item{plateperiod}{(\code{logical}) Argument of the local reconstruction submodule. Should the durations of the plates be forced on the partitioned feature? If these are set to \code{TRUE} and the plate duration estimates are long, then you might lose some data.}
}
\value{
A \code{numeric} matrix if \code{x} is a \code{numeric}, \code{matrix} or \code{data.frame}, or \code{Spatial*} class objects, depending on input.
}
\description{
Reconstruct the geographic locations from present day coordinates and spatial objects back to their paleo-positions. 
Each location will be assigned a plate id and moved back in time using the chosen reconstruction model.
}
\details{
The function implements two reconstruction submodules, which are selected with the \code{model} argument:

If \code{model} is a \code{character} entry, then the \code{reconstruct()} function uses the GPlates Web Service (\url{https://gws.gplates.org/}, remote reconstruction submodule).
The available reconstruction models for this submodule are:
\itemize{
 \item "SETON2012" (Seton et al., 2012) for coastlines and plate polygons.
 \item "MULLER2016" (Muller et al., 2016) for coastlines and plate polygons.
 \item "GOLONKA" (Wright et al. 2013) for coastlines only. 
 \item "PALEOMAP" (Scotese and Wright, 2018) for coastlines and plate polygons. 
 \item "MATTHEWS2016" (Matthews et al., 2016) for coastlines and plate polygons. 
}

If \code{model} is a \code{\link{platemodel}} class object, then the function will try to use the GPLates desktop application (\url{https://www.gplates.org/}) to reconstruct the coordinates (local reconstruction submodule).
Plate models are available in chronosphere with the \code{\link{fetch}} function. See \code{\link{datasets}} for the available models.
The function will try to find the main GPlates executable in its default installation directory. If this does not succeed, use \code{path.gplates} to enter the full path to the GPlates executable as a \code{character} string.
}
\section{References}{

Matthews, K. J., Maloney, K. T., Zahirovic, S., Williams, S. E., Seton, M., & Müller, R. D. (2016). Global plate boundary evolution and kinematics since the late Paleozoic. Global and Planetary Change, 146, 226–250. https://doi.org/10.1016/j.gloplacha.2016.10.002
\cr
\cr Müller, R. D., Seton, M., Zahirovic, S., Williams, S. E., Matthews, K. J., Wright, N. M., … Cannon, J. (2016). Ocean Basin Evolution and Global-Scale Plate Reorganization Events Since Pangea Breakup. Annual Review of Earth and Planetary Sciences, 44(1), 107–138. https://doi.org/10.1146/annurev-earth-060115-012211
\cr
\cr Scotese, C., & Wright, N. M. (2018). PALEOMAP Paleodigital Elevation Models (PaleoDEMS) for the Phanerozoic PALEOMAP Project. Retrieved from https://www.earthbyte.org/paleodem-resource-scotese-and-wright-2018/
\cr
\cr Seton, M., Müller, R. D., Zahirovic, S., Gaina, C., Torsvik, T., Shephard, G., … Chandler, M. (2012). Global continental and ocean basin reconstructions since 200Ma. Earth-Science Reviews, 113(3–4), 212–270. https://doi.org/10.1016/j.earscirev.2012.03.002
\cr
\cr Wright, N., Zahirovic, S., Müller, R. D., & Seton, M. (2013). Towards community-driven paleogeographic reconstructions: integrating open-access paleogeographic and paleobiology data with plate tectonics. Biogeosciences, 10(3), 1529–1541. https://doi.org/10.5194/bg-10-1529-2013
}

\examples{
\donttest{
# With the web service (GPlates Web Service was offline at submission)
# simple matrices
# reconstruct(matrix(c(95, 54), nrow=1), 140)

# points reconstruction
xy <-cbind(long=c(95,142), lat=c(54, -33))
# reconstruct(xy, 140)

# coastlines/plates
# coast <- reconstruct("coastlines", 140)
# plate <- reconstruct("plates", 139)

 }
}
