% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmasgalton.R
\name{xmasgalton}
\alias{xmasgalton}
\title{Christmas Galton card.}
\usage{
xmasgalton(
  year = 2019,
  language = c("english", "spanish", "catalan"),
  balls = 240,
  layers = 15,
  onlyBoard = FALSE,
  treeballs = 15,
  time = 0.02,
  seed = NULL
)
}
\arguments{
\item{year}{Year to be printed. Default is \code{2019}.}

\item{language}{Language to be used in the card. One of \code{c("english",
"spanish", "catalan")}. Default is \code{"english"}.}

\item{balls}{The number of balls in the board. Default is 240.}

\item{layers}{The number of layers in the board. Default is 15.}

\item{onlyBoard}{Logical. If \code{FALSE} (default), an empirical Christmas
normal tree estimated from data is added to the histogram.}

\item{treeballs}{The number of balls to be added to the Christmas normal
tree. Default is 15.}

\item{time}{Elapsed time, in seconds, between two consecutive balls in the
board. Default is 0.02.}

\item{seed}{Seed for reproducibility of the card. Default is \code{NULL} (no
seed).}
}
\value{
A Christmas tree in a Galton board.
}
\description{
Christmas Galton card (2018). A Christmas tree in the Galton
  board. This is an adaptation of \code{quincunx()} in package
  \code{animation}, which simulates the Galton board
  (\url{https://en.wikipedia.org/wiki/Bean_machine}).
}
\examples{
\donttest{
xmasgalton()
# more balls, less layers:
xmasgalton(balls = 300, layers = 9)
# no balls in the gaussian christmas tree:
xmasgalton(balls = 400, layers = 11, time = 0.005, treeballs = 0)
}
}
\author{
Jose Barrera-Gomez.
}
