% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_congressional_demographics.R
\name{visualize_df_by_race_ethnicity_party}
\alias{visualize_df_by_race_ethnicity_party}
\title{Create box plots to visualize race and ethnicity by party}
\usage{
visualize_df_by_race_ethnicity_party(df)
}
\arguments{
\item{df}{A data.frame with columns "party", "percent_white", "percent_black", "percent_asian", "percent_hispanic"}
}
\description{
Requires a data.frame with specific column names. In practice, the data.frame is expected
to come from a function like ?get_congressional_districts and then merged with a data.frame 
that has column "party".
}
\examples{
data("df_congress116_demographics")
data("df_congress116_party")
df = merge(df_congress116_demographics, df_congress116_party)
# Race and Ethnicity of the 116th Congressional Districts using data from
# the 2018 5-year American Community Survey
visualize_df_by_race_ethnicity_party(df) 
}
