% Generated by roxygen2 (4.0.2): do not edit by hand
\name{county_choropleth}
\alias{county_choropleth}
\title{Create a choropleth of USA Counties with sensible defaults.}
\usage{
county_choropleth(df, title = "", legend = "", buckets = 7, zoom = NULL)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in
the "region" column must exactly match how regions are named in the "region" column in county.map.}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{buckets}{The number of equally sized buckets to places the values in.  A value of 1
will use a continuous scale, and a value in [2, 9] will use that many buckets.}

\item{zoom}{An optional vector of states to zoom in on. Elements of this vector must exactly
match the names of states as they appear in the "region" column of ?state.regions.}
}
\description{
The map used is county.map in the choroplethrMaps package.  See country.regions
in the choroplethrMaps package for an object which can help you coerce your regions
into the required format.
}
\examples{
\dontrun{
# demonstrate default parameters - visualization using 7 equally sized buckets
data(df_pop_county)
county_choropleth(df_pop_county, title="US 2012 County Population Estimates", legend="Population")

#' # demonstrate continuous scale and zoom
data(df_pop_county)
county_choropleth(df_pop_county,
                 title="US 2012 County Population Estimates",
                 legend="Population",
                 buckets=1,
                 zoom=c("california", "oregon", "washington"))

# demonstrate how choroplethr handles character and factor values
# demonstrate user creating their own discretization of the input
data(df_pop_county)
df_pop_county$str = ""
for (i in 1:nrow(df_pop_county))
{
  if (df_pop_county[i,"value"] < 1000000)
  {
    df_pop_county[i,"str"] = "< 1M"
  } else {
    df_pop_county[i,"str"] = "> 1M"
  }
}
df_pop_county$value = df_pop_county$str
county_choropleth(df_pop_county, title="Which counties have more than 1M people?")
}
}

