% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-length.R
\name{chk_length}
\alias{chk_length}
\alias{vld_length}
\title{Check Length}
\usage{
chk_length(x, length = 1L, x_name = NULL)

vld_length(x, length = 1L)
}
\arguments{
\item{x}{The object to check.}

\item{length}{A count of the length.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks length is a particular value using

\code{length(x) == length}
}
\section{Functions}{
\itemize{
\item \code{vld_length}: Validate Length
}}

\examples{
# chk_length
chk_length("text")
try(vld_length("text", length = 2))
# vld_length
vld_length(2:1, 2)
vld_length(2:1, 1)
}
\seealso{
\code{\link[=check_dim]{check_dim()}}

Other chk_misc: 
\code{\link{chk_match}()},
\code{\link{chk_named}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_empty}()},
\code{\link{chk_sorted}()},
\code{\link{chk_unique}()}
}
\concept{chk_misc}
