% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-atomic.R
\name{chk_atomic}
\alias{chk_atomic}
\alias{vld_atomic}
\title{Check Atomic}
\usage{
chk_atomic(x, x_name = NULL)

vld_atomic(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if atomic using

\code{is.atomic(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_atomic}: Validate Atomic
}}

\examples{

# chk_atomic
chk_atomic(1)
try(chk_atomic(list(1)))

# vld_atomic
vld_atomic(1)
vld_atomic(matrix(1:3))
vld_atomic(character(0))
vld_atomic(list(1))
vld_atomic(NULL)
}
\seealso{
Other chk_is: 
\code{\link{chk_array}()},
\code{\link{chk_environment}()},
\code{\link{chk_function}()},
\code{\link{chk_list}()},
\code{\link{chk_matrix}()},
\code{\link{chk_numeric}()},
\code{\link{chk_s3_class}()},
\code{\link{chk_s4_class}()},
\code{\link{chk_vector}()},
\code{\link{chk_whole_numeric}()}
}
\concept{chk_is}
