% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-range.R
\name{chk_range}
\alias{chk_range}
\alias{vld_range}
\title{Checks range of non-missing values}
\usage{
chk_range(x, range = c(0, 1), x_name = NULL)

vld_range(x, range = c(0, 1))
}
\arguments{
\item{x}{The object to check.}

\item{range}{A non-missing sorted vector of length 2 of the lower and upper permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.

The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks all non-missing values fall within range using

\code{all(x[!is.na(x)] >= range[1] & x[!is.na(x)] <= range[2])}
}
\section{Functions}{
\itemize{
\item \code{vld_range}: Validate Range
}}

\examples{

# chk_range
chk_range(0)
try(chk_range(-0.1))

# vld_range
vld_range(numeric(0))
vld_range(0)
vld_range(-0.1)
vld_range(c(0.1, 0.2, NA))
vld_range(c(0.1, 0.2, NA), range = c(0, 1))
}
\seealso{
Other chk_ranges: 
\code{\link{chk_gte}()},
\code{\link{chk_gt}()},
\code{\link{chk_lte}()},
\code{\link{chk_lt}()}
}
\concept{chk_ranges}
