% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temp_models.R
\name{Dynamic_Model}
\alias{Dynamic_Model}
\title{Calculation of cumulative chill according to the Dynamic Model}
\usage{
Dynamic_Model(HourTemp, summ = TRUE)
}
\arguments{
\item{HourTemp}{Vector of hourly temperatures.}

\item{summ}{Boolean parameter indicating whether calculated metrics should
be provided as cumulative values over the entire record (TRUE) or as the
actual accumulation for each hour (FALSE).}
}
\value{
Vector of length length(HourTemp) containing the cumulative Chill
Portions over the entire duration of HourTemp.
}
\description{
This function calculates winter chill for temperate trees according to the
Dynamic Model.
}
\details{
Chill Portions are calculated as suggested by Erez et al. (1990).
}
\examples{

weather<-fix_weather(KA_weather[which(KA_weather$Year>2006),])

hourtemps<-stack_hourly_temps(weather,latitude=50.4)

Dynamic_Model(hourtemps$hourtemps$Temp)

}
\author{
Eike Luedeling
}
\references{
Dynamic Model references:

Erez A, Fishman S, Linsley-Noakes GC, Allan P (1990) The dynamic model for
rest completion in peach buds. Acta Hortic 276, 165-174

Fishman S, Erez A, Couvillon GA (1987a) The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. J Theor Biol 126(3), 309-321

Fishman S, Erez A, Couvillon GA (1987b) The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. J Theor Biol 124(4), 473-483
}
\keyword{and}
\keyword{calculation}
\keyword{chill}
\keyword{heat}

