% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createlms.R
\name{do_iterations}
\alias{do_iterations}
\title{do lms iterations}
\usage{
do_iterations(data.list, n = 10, prop.fam = 0.75, prop.subject = 1,
  age.min = 0, age.max = 18, age.int = 1/12, dist = "BCCGo",
  mu.df = 4, sigma.df = 3, nu.df = 2, tau.df = 2)
}
\arguments{
\item{data.list}{list of dataframes as returned by prepare_data}

\item{n}{number of iterations}

\item{prop.fam}{proportion of families to be sampled}

\item{prop.subject}{proportion of subject to be sampled}

\item{age.min}{lower bound of age}

\item{age.max}{upper bound of age}

\item{age.int}{stepwidth of the age variable}

\item{dist}{distribution used for the fitting process, has to be one of BCCGo, BCPEo, BCTo as they are accepted by lms()}

\item{mu.df}{degree of freedem location parameter}

\item{sigma.df}{degree of freedem spread parameter}

\item{nu.df}{degree of freedem skewness parameter}

\item{tau.df}{degree of freedem kurtosis parameter}
}
\value{
list of lists for models and fitted parameters
}
\description{
Do lms iterations
}
\details{
function samples families, samples measurements (and subjects), fits the model for a
given number of iterations
}
\author{
Mandy Vogel
}
