% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.split.R
\name{distance.split}
\alias{distance.split}
\title{distance.split}
\usage{
distance.split(interaction.data, distance.bins = NULL,
  min.rows.bin = 50, verbose = FALSE)
}
\arguments{
\item{interaction.data}{Data table of interaction data, typically from \code{prepare.data}}

\item{distance.bins}{Number of distance bins desired. If NULL, a number is chosen to ensure that the negative binomial can be fit in all bins.}

\item{min.rows.bin}{The minimum number of expected rows in a distance bin. Ignored if distance.bins is set}

\item{verbose}{Logical indicating whether to print progress reports}
}
\value{
List where each element corresponds to a specified distance bin, and the final one corresponding to trans-interactions (if present)
}
\description{
Split interaction data into subsets that are large enough for the chicane model to be fit (see Details), 
based on distance. This step allows the distance term in the model to be fit in a piecewise linear fashion.
}
\details{
Fitting \code{glm.nb} fails when there is a lack of overdispersion in the data. The chicane method
	contains logic to catch these errors and instead fit a Poisson model. However, to avoid this happening
	more than necessary, an attempt is made to avoid distance splits that will clearly result in numerical errors.
	This includes bins of data where the count is the same for all rows, 
or a covariate is a perfect predictor of count.
}
\examples{
data(bre80);
distance.split(bre80);

}
