% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbt04.R
\docType{data}
\name{lbt04_main}
\alias{lbt04_main}
\alias{lbt04_pre}
\alias{lbt04_post}
\alias{lbt04}
\title{\code{LBT04} Laboratory Abnormalities Not Present at Baseline Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
lbt04_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  analysis_abn_var = "ANRIND",
  baseline_abn_var = "BNRIND",
  row_split_var = "PARCAT1",
  page_var = tail(row_split_var, 1L),
  ...
)

lbt04_pre(adam_db, ...)

lbt04_post(tlg, ...)

lbt04
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{analysis_abn_var}{(\code{string}) column describing anomaly magnitude}

\item{baseline_abn_var}{(\code{string}) column describing anomaly at baseline.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{LBT04} table provides an
overview of laboratory abnormalities not present at baseline.
}
\details{
\itemize{
\item Only count LOW or HIGH values.
\item Lab test results with missing \code{analysis_abn_var} values are excluded.
\item Split columns by arm, typically \code{ACTARM}.
\item Does not include a total column by default.
}
}
\section{Functions}{
\itemize{
\item \code{lbt04_main()}: Main TLG function

\item \code{lbt04_pre()}: Preprocessing

\item \code{lbt04_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adlb} table with columns \code{"PARCAT1"}, \code{"PARCAT2"}, \code{"PARAM"}, \code{"ANRIND"},
and column specified by \code{arm_var}.
}
}
\examples{
run(lbt04, syn_data)
}
\keyword{datasets}
