% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_args.R
\name{gen_args}
\alias{gen_args}
\title{General Argument Name Convention}
\usage{
gen_args(
  adam_db,
  main,
  preprocess,
  postprocess,
  dataset,
  type,
  arm_var,
  lbl_overall,
  prune_0,
  req_tables,
  deco,
  group,
  tlg,
  visitvar,
  visit_value,
  paramcd_value,
  key_cols,
  disp_cols,
  row_split_var,
  page_var,
  unique_rows,
  ...
)
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{main}{(\code{function}) returning a \code{tlg}, with \code{adam_db} as first argument. Typically one of the \verb{_main} function
of \code{chevron}.}

\item{preprocess}{(\code{function}) returning a pre-processed \code{list} of \code{data.frames}, with \code{adam_db} as first argument.
Typically one of the \verb{_pre} function of \code{chevron}.}

\item{postprocess}{(\code{function}) returning a post-processed \code{tlg}, with \code{tlg} as first argument.}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{type}{(\code{string}) indicating the subclass.}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{prune_0}{(\code{flag}) remove 0 count rows}

\item{req_tables}{(\code{character}) names of the required tables.}

\item{deco}{(\code{character}) decoration with \code{title}, \code{subtitles} and \code{main_footer} content}

\item{group}{(\verb{list of lists}) for group-dependent data binning}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{visitvar}{(\code{string}) typically \code{"AVISIT"} or user-defined visit incorporating \code{"ATPT"}.}

\item{visit_value}{Value of visit variable.}

\item{paramcd_value}{Value of \code{PARAMCD} variable.}

\item{key_cols}{(\code{character}) names of columns that should be treated as key columns when rendering the listing.
Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character}) names of non-key columns which should be displayed when the listing is rendered.}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{page_var}{(\code{string}) variable name prior to which the row split is by page.}

\item{unique_rows}{(\code{flag}) whether to keep only unique rows in listing.}

\item{...}{not used.}
}
\value{
invisible \code{NULL}. This function is for documentation purpose only.
}
\description{
General Argument Name Convention
}
\details{
the following arguments are better provided through the study object: \code{lbl_overall}, \code{arm_var}.
}
