% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_forest.R
\name{chest_forest}
\alias{chest_forest}
\title{Plot effect estimates and change-in-estimate values (forestplot type)}
\usage{
chest_forest(
  data,
  var_lab = "Variables",
  est_lab = "Estimate (95\% CI)",
  change_lab = "Change, \%",
  digits = "\%.2f",
  digits_change = "\%.1f",
  hrzl_lines = gpar(col = "#444444"),
  plus = "  + ",
  ...
)
}
\arguments{
\item{data}{\emph{Object} from \code{chest_cox}, \code{chest_glm},
\code{chest_speedglm}, \code{chest_lm}, \code{chest_clogit}, or \code{chest_nb},
including effect estimate values and change-in-estimate values.}

\item{var_lab}{\emph{Character} string for the column name of variables in the graph.}

\item{est_lab}{\emph{Character} string for the column name of effect estimates.}

\item{change_lab}{\emph{Character} string for the column name of "Changes".}

\item{digits}{Set the display format for number in the graph other than the \emph{"Change"} column. Default: "\%.2f"}

\item{digits_change}{Set the format for the \emph{"Change"} column. Default: "\%.1f"}

\item{hrzl_lines}{A \emph{logic} to include or remove horizontal line.}

\item{plus}{Change the \code{+} sign before variable names.}

\item{...}{Further optional arguments for forestplot.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
\code{'chest_forest'} plots effect estimates and change-in-estimate values
with \code{forestplot} package.
}
\examples{
vlist <- c("Age", "Sex", "Married", "Cancer", "CVD", "Education", "Income")
results <- chest_cox(crude = "Surv(t0, t1, Endpoint) ~ Diabetes", xlist = vlist, data = diab_df)
chest_forest(results)
}
\seealso{
\pkg{'forestplot'}
}
