% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{linear_tform}
\alias{linear_tform}
\title{Linear function to help set alpha opacity}
\usage{
linear_tform(n, appox_max_n = 5000L, ceiling = 1, floor = 0.3)
}
\arguments{
\item{n}{Number of observations to plot.}

\item{appox_max_n}{The number of observation to reach floor opacity.}

\item{ceiling}{The highest number returned. Defaults to 1.}

\item{floor}{The lowest number returned. Defaults to 0.3.}
}
\value{
A scalar numeric, suggested value to set alpha opacity.
}
\description{
Suggests a alpha opacity to plot with as a function of the number of
observation.
}
\examples{
library(cheem)

## Suggest an opacity to use in plotting:
(my_alpha <- linear_tform(nrow(spinifex::penguins_na.rm)))

## Visualize
x <- 1:2000
plot(x, sapply(x, linear_tform), col = "blue")
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{basis_attr_df}()},
\code{\link{color_scale_of}()},
\code{\link{does_contain_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{logistic_tform}()},
\code{\link{manip_var_of_attr_df}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()}
}
\concept{cheem utility}
