% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_cheem_lists.r
\name{default_rf}
\alias{default_rf}
\title{Random forest model via randomForest}
\usage{
default_rf(
  x,
  y,
  verbose = getOption("verbose"),
  hp_ntree = 125,
  hp_mtry = ifelse(is_discrete(y), sqrt(ncol(x)), ncol(x)/3),
  hp_nodesize = max(ifelse(is_discrete(y), 1, 5), nrow(x)/500)
)
}
\arguments{
\item{x}{The explanatory variables of the model.}

\item{y}{The target variable of the model.}

\item{verbose}{Logical, if runtime should be printed. Defaults to TRUE.}

\item{hp_ntree}{Hyperparameter, the number of trees to grow.}

\item{hp_mtry}{Hyperparameter, the number variables randomly sampled at
each split.}

\item{hp_nodesize}{Hyperparameter, the minimum size of terminal nodes.
Setting this number larger causes smaller trees to be grown (and thus take less time).}
}
\value{
A randomForest model.
}
\description{
A wrapper function for \code{randomForest::randomForest} with more modest
hyperparameter defaults and arguments consistent with \code{cheem}.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model, treeSHAP, cheem list, visualize
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                    model = rf_fit,
                    attr_df = shap_df)
global_view(this_ls)
}
\seealso{
Other cheem preprocessing: 
\code{\link{attr_df_treeshap}()},
\code{\link{cheem_ls}()}
}
\concept{cheem preprocessing}
