% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorted.R
\name{check_sorted}
\alias{check_sorted}
\title{Check Sorted}
\usage{
check_sorted(x, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether object x is sorted.
}
\details{
Uses \code{!is.unsorted(x, na.rm = TRUE)} to test.
}
\examples{
check_sorted(1:2, error = FALSE)
check_sorted(2:1, error = FALSE)
}
