% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDate.r
\name{checkDate}
\alias{assertDate}
\alias{assert_date}
\alias{checkDate}
\alias{expect_date}
\alias{testDate}
\alias{test_date}
\title{Check that an argument is a Date}
\usage{
checkDate(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE)

assertDate(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, add = NULL, .var.name = NULL)

assert_date(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, add = NULL, .var.name = NULL)

testDate(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE)

test_date(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE)

expect_date(x, lower = NULL, upper = NULL, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{lower}{[\code{\link[base]{Date}}]\cr
All dates in \code{x} must be after this date. Comparison is done via \code{\link[base]{Ops.Date}}.}

\item{upper}{[\code{\link[base]{Date}}]\cr
All dates in \code{x} must be before this date. Comparison is done via \code{\link[base]{Ops.Date}}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertAtmoic}/\code{assert_atmoic}
 throws an error message, \code{testAtmoic}/\code{test_atmoic}
 returns \code{FALSE},
 and \code{checkAtmoic} returns a string with the error message.
 The function \code{expect_atmoic} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Checks that an object is of class \code{\link[base]{Date}}.
}

