% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkSetEqual.r
\name{checkSetEqual}
\alias{assertSetEqual}
\alias{checkSetEqual}
\alias{testSetEqual}
\title{Check if object is a subset of a given set}
\usage{
checkSetEqual(x, y, ordered = FALSE)

assertSetEqual(x, y, ordered = TRUE, .var.name)

testSetEqual(x, y, ordered = TRUE)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{y}{[\code{atomic}]\cr
Set to compare with.}

\item{ordered}{[\code{logical(1)}]\cr
Check \code{x} to have the same length and order as \code{y}, i.e.
check using \dQuote{==} while handling \code{NA}s nicely.
Default is \code{FALSE}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertSubset} throws an error message,
 \code{testSubset} returns \code{FALSE} and \code{checkSubset} returns
 a string with the error message.
}
\description{
Check if object is a subset of a given set
}
\examples{
testSetEqual(c("a", "b"), c("a", "b"))
 testSetEqual(1:3, 1:4)
}
\seealso{
Other set: \code{\link{assertChoice}},
  \code{\link{checkChoice}}, \code{\link{testChoice}};
  \code{\link{assertSubset}}, \code{\link{checkSubset}},
  \code{\link{testSubset}}
}

