% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkScalarNA}
\alias{assertScalarNA}
\alias{checkScalarNA}
\alias{testScalarNA}
\title{Check if an argument is a single missing value}
\usage{
checkScalarNA(x)

assertScalarNA(x, .var.name)

testScalarNA(x)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertScalarNA} throws an error message,
 \code{testScalarNA} returns \code{FALSE} and \code{checkScalarNA} returns
 a string with the error message.
}
\description{
Check if an argument is a single missing value
}
\examples{
testScalarNA(1)
testScalarNA(NA_real_)
testScalarNA(rep(NA, 2))
}
\seealso{
Other scalars: \code{\link{assertCount}},
  \code{\link{checkCount}}, \code{\link{testCount}};
  \code{\link{assertFlag}}, \code{\link{checkFlag}},
  \code{\link{testFlag}}; \code{\link{assertInt}},
  \code{\link{checkInt}}, \code{\link{testInt}};
  \code{\link{assertNumber}}, \code{\link{checkNumber}},
  \code{\link{testNumber}}; \code{\link{assertScalar}},
  \code{\link{checkScalar}}, \code{\link{testScalar}};
  \code{\link{assertString}}, \code{\link{checkString}},
  \code{\link{testString}}
}

