% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task.R
\name{install_task}
\alias{install_task}
\title{Create a task to install a package and dependencies}
\usage{
install_task(
  origin,
  type = package_install_type(origin),
  INSTALL_opts = NULL,
  lib = lib_path(origin),
  ...
)
}
\arguments{
\item{origin}{\code{\link[=pkg_origin]{pkg_origin()}} object.}

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{INSTALL_opts}{
    an optional character vector of additional option(s) to be passed to
    \command{R CMD INSTALL} for a source package install.  E.g.,
    \code{c("--html", "--no-multiarch", "--no-test-load")} or, for
    macOS, \code{"--dsym"}.

    Can also be a named list of character vectors to be used as
    additional options, with names the respective package names.
  }

\item{lib}{Any object that can be passed to \code{\link[=lib]{lib()}} to generate a library
path.}

\item{...}{
    further arguments to be passed to \code{\link[utils]{download.file}},
    \code{\link[utils]{available.packages}}, or to the functions for binary
    installs on macOS and Windows (which accept an argument \code{"lock"}:
    see the section on \sQuote{Locking}).
  }
}
\description{
Create a task to install a package and dependencies
}
\seealso{
Other tasks: 
\code{\link{check_task}()},
\code{\link{meta_task}()},
\code{\link{task}()}
}
\concept{tasks}
