% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfd.semipar.quantile.R
\name{cfd.semipar.quantile}
\alias{cfd.semipar.quantile}
\title{Quantile Decomposition: semiparametric version}
\usage{
cfd.semipar.quantile(
  formula,
  mediator,
  group,
  strata = NA,
  nbin = 5,
  data,
  family = "Gaussian",
  bs.size = 1000,
  mc.size = 50,
  alpha = 0.05,
  probs = 0.5,
  print.iteration = FALSE
)
}
\arguments{
\item{formula}{the \code{\link{formula}} for the multivariable model (see \code{\link{glm}}) for the outcome Y.}

\item{mediator}{the column name of the mediator M.}

\item{group}{column name of the variable containing the group identifier.}

\item{strata}{the name of a variable containing the strata of a third variable (or set of variables) within which we equalize mediator values.}

\item{nbin}{if a numeric (i.e. non-factor or character) strata variable is defined, how many bins should be made from it within which we equalize the mediator distribution?}

\item{data}{a data frame containing the variables in the model.}

\item{family}{a description of the error distribution to be used in the model, see \code{\link{family}} for details. For the outcome variable any member of the \code{glm} family can be used.}

\item{bs.size}{the number of bootstrap iterations to be performed.}

\item{mc.size}{the number of Monte Carlo iterations to be performed (more = more MC error reduction).}

\item{alpha}{the alpha level used to construct confidence intervals (0.05 = 95 percent confidence interval).}

\item{probs}{the quantiles of interest to be decomposed, should be values between 0 and 1.}

\item{print.iteration}{print the bootstrap iteration}
}
\value{
\code{out_nc} returns the mean level of the outcome under the natural course, which is a value that should be close to the empirically observed value of the outcome for each group. \code{out_nc_quantile} provides the \code{alpha/2} and \code{1-alpha/2} bootstrap quantiles for this mean (AKA bootstrap percentile confidence intervals).Similarly, \code{out_cf}, \code{out_cf_quantile},provide the corresponding values for the counterfactual scenario where the mediators of the groups are equalized. \code{mediation} returns the proportion mediated by setting the intervened on mediator to be equal in level to the reference group and \code{mediation_quantile} returns the 1-alpha confidence interval.
}
\description{
Decompose the difference in a quantile of some outcome Y between groups. In this semiparametric version, we do not assume a parametric model for the mediator: instead, we sample from the distribution of the mediator in the reference group; this can be done within strata of one or more third variables.
}
\examples{
set.seed(100)
# the decomposition functions in our package are computationally intensive
# to make the example run quick, I perform it on a subsample (n=500) of the data:
cfd.example.sample <- cfd.example.data[sample(500),]
quantile.semipar.results.1 <- cfd.semipar.quantile(formula='out.gauss ~ SES +
                                                  med.gauss + med.binom + age',
                                                  mediator='med.gauss',
                                                  group='SES',
                                                  strata='age',
                                                  nbin=5,
                                                  data=cfd.example.sample,
                                                  family='gaussian',
                                                  bs.size=50,
                                                  mc.size=10,
                                                  alpha=0.05,
                                                  probs=0.50)
# also note that normally we would recommend an bs.size of 250+
# and an mc.size of 50+
# see README.md for a more detailed description of the functions in this package.
}
