% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretreatment.R
\name{remove_duplicated_states}
\alias{remove_duplicated_states}
\title{Remove duplicated states}
\usage{
remove_duplicated_states(data, keep.last = TRUE)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}

\item{keep.last}{if TRUE, keep the last state for every individual even if it is a duplicated state.}
}
\value{
\code{data} without duplicated consecutive states
}
\description{
Remove duplicated consecutive states from data. If for an individual there is two or more consecutive states that are identical,
only the first is kept. Only time when the state changes are kept.
}
\examples{
data <- data.frame(
  id = rep(1:3, c(10, 3, 8)), time = c(1:10, 1:3, 1:8),
  state = c(rep(1:5, each = 2), 1:3, rep(1:3, c(1, 6, 1)))
)
out <- remove_duplicated_states(data)
}
\author{
Quentin Grimonprez
}
