% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{plot.pt}
\alias{plot.pt}
\title{Plot probabilities}
\usage{
\method{plot}{pt}(x, col = NULL, ribbon = FALSE, ...)
}
\arguments{
\item{x}{output of \code{\link{estimate_pt}}}

\item{col}{a vector containing color for each state}

\item{ribbon}{if TRUE, use ribbon to plot probabilities}

\item{...}{only if \code{ribbon = TRUE}, parameter \code{addBorder}, if TRUE, add black border to the ribbons.}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Plot the probabilities of each state at each given time
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

d_JK2 <- cut_data(d_JK, 10)

pt <- estimate_pt(d_JK2)

plot(pt, ribbon = TRUE)
}
\author{
Quentin Grimonprez
}
