% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEncoding.R
\name{plotEigenvalues}
\alias{plotEigenvalues}
\title{Plot Eigenvalues}
\usage{
plotEigenvalues(x, cumulative = FALSE, normalize = FALSE, ...)
}
\arguments{
\item{x}{output of \code{\link{compute_optimal_encoding}} function}

\item{cumulative}{if TRUE, plot the cumulative eigenvalues}

\item{normalize}{if TRUE eigenvalues are normalized for summing to 1}

\item{...}{\code{geom_point} parameters}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Plot Eigenvalues
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
Tmax <- 6
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = Tmax)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 6
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)
\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

# plot eigenvalues
plotEigenvalues(encoding, cumulative = TRUE, normalize = TRUE)

# modify the plot using ggplot2
library(ggplot2)
plotEigenvalues(encoding, shape = 23) +
  labs(caption = "Jukes-Cantor model of nucleotide replacement")
}


}
\seealso{
Other encoding functions: 
\code{\link{compute_optimal_encoding}()},
\code{\link{get_encoding}()},
\code{\link{plot.fmca}()},
\code{\link{plotComponent}()},
\code{\link{predict.fmca}()},
\code{\link{print.fmca}()},
\code{\link{summary.fmca}()}
}
\author{
Quentin Grimonprez
}
\concept{encoding functions}
