\name{relax.cem}
\alias{relax.cem}
\alias{relax.plot}
\title{Diagnostic tool for CEM}
\description{
Diagnostic tools for CEM
}
\usage{
relax.cem(obj, data, depth=1, verbose = 1, L1.breaks=NULL, plot=TRUE, fixed=NULL, 
 shifts=NULL, minimal=NULL, use.coarsened=TRUE, eval.imbalance=TRUE, ...)
relax.plot(tab, group="1", max.terms=50, perc=.5, unique=FALSE, colors=TRUE)
}
\arguments{
  \item{obj}{an object of class cem.}
  \item{data}{the original data.}
  \item{verbose}{controls the level of verbosity.}
  \item{L1.breaks}{list of cutpoints for the calculation of the L1 measure.}
  \item{plot}{plot the solutions?}  
  \item{tab}{the output table from \code{relax.cem}.}  
  \item{fixed}{vector of variable names which will not be relaxed.}  
  \item{max.terms}{plot only the last best results of \code{relax.cem}.}  
  \item{shifts}{a vector of proportions of shifts.}
  \item{minimal}{the minimal number of intervals acceptable after
  relaxation. Should be a nameed list of positive integers.}
  \item{group}{character string denoting group id. Defaults to \code{"1"}.}
  \item{perc}{only plot if percentage of matched units is greater than \code{perc}.}
  \item{unique}{only plot different solutions (in terms of matched units).}
  \item{depth}{if 1, relaxes up to dropping one var, if 2 relaxes (up to
  dropping) two vars, etc.}
  \item{use.coarsened}{used coarsened values for continuous variables.}
  \item{colors}{If \code{TRUE} each variable is plotted in a different colour.}
  \item{eval.imbalance}{If \code{TRUE} L1 measure is evaluated at each iteration.}
  \item{...}{passed to the \code{relax.plot} function.}
}

\details{
  \code{relax.cem} starts from a cem solution (as given by
  \code{\link{cem}}) and tries several relaxed coarsenings on the
  variables. Coarsenings corresponds to dividing the support of each
  variable into a decreasing number of intervals of the same length (even
  if in the starting solution intervals are of different lengths).
  Because CEM is MIB, the number of matched units increases as the
  number of intervals decrease.  All variables are coarsened into
  \code{k} intervals along a sequence which starts from the original
  number of intervals and decreases to 10 intervals by 2,
  then continues from 10 down to 1 intervals by 1. If
  \code{minimal} is specified, variables are coarsened down to that
  minimal value.

To observe MIB property of CEM \code{use.coarsened} (default) should be
set to \code{TRUE}; otherwise the coarsening of the continuous variable
will be recalculated at each iteration and there is no guarantee of
monotonicity.

\code{relax.cem} outputs a list of tables. Each table is named
\code{Ggroup} where \code{group} is the id of the group.  Each
\code{Ggroup} table is ordered in increasing order of matched units of
group \code{group}.  Columns \code{PercGgroup} and \code{Ggroup} report
percentage and absolute number of matched units for each \code{group}.
Column \code{Relaxed} indicates which relaxation has been done, with
something like \code{"V1(4), V3(5)"}, which means "variable \code{V1}
has been split in 4 intervals of the same length and variable \code{V3}
into five intervals".  Thus, the number of intervals is reported in
parenthases and if equal to 1 means that the corresponding variable is
excluded from affecting the match (i.e. all observations are assigned to
the same interval).

If \code{shifts} is not null, each coarsening is shifted accordingly
(see \code{\link{shift.cem}} for additional details).  In case of
shifting ``\code{S:}'' appears in the labels.  

The \code{relax.plot}, plot all the different relaxation in increasing
order of number of treated units matched. For each coarsening it also reports
the value of the L1 measure. The table generated by \code{relax.cem} may 
contain many entries. By default, only a portion of best coarsenings
are plotted (option \code{max.terms}). In addition, the user can specify
to plot the corasening for which at least a certain percentage of
treated units have been matched (option \code{perc}, by default 50%).
In addition, of several different coarsenings which lead to the same number of treated 
units matched, the user can specify to plot only one of them using the
option \code{unique} = \code{TRUE} (default).

If \code{L1.breaks} are \code{NULL} they are taken from the \code{cem} object 
if available or calculated atumatically as in \code{cem}.

Calling directly \code{plot} on the output of \code{cem.relax} has the same
effect of calling directly \code{relax.plot}.

} 
\value{
  \item{tab}{an invisible object containing the tabs and the L1breaks
  used}
}
\references{Stefano Iacus, Gary King, Giuseppe Porro, ``Matching for
  Casual Inference Without Balance Checking: Coarsened Exact Matching,''
  http://gking.harvard.edu/files/abs/cem-abs.shtml}
\author{Stefano Iacus, Gary King, and Giuseppe Porro}
\seealso{ \code{\link{cem}} }
\examples{
data(LL)

mat <- cem(treatment="treated",data=LL, drop="re78")
mat
tab <- relax.cem(mat, LL, depth=1, plot=FALSE)

relax.plot(tab, group="1")
plot(tab, group="1")
relax.plot(tab, group="1", unique=TRUE)
relax.plot(tab, group="1", perc=0.6)
relax.plot(tab, group="1", perc=0.6,unique=TRUE)

tab1 <- relax.cem(mat, LL, depth=1, minimal=list(re74=6, age=3, education=3, re75=5))
tab2 <- relax.cem(mat, LL, depth=1, minimal=list(re74=6, age=3,
                  education=3, re75=5), shifts=0.01)
tab3 <- relax.cem(mat, LL, depth=1, minimal=list(age=3, education=3),
                  fixed=c("re74","re75"))


# uncomment to run. Might be slow
# tab4 <- relax.cem(mat, LL, depth=2, minimal=list(age=4,
#                   education=3,re75=6),plot=FALSE, fixed="re74")
# relax.plot(tab4)
# relax.plot(tab4, unique=TRUE)
# relax.plot(tab4, perc=0.7)
 
}
\keyword{datagen}

