% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scedasticity.R
\name{plot_residuals}
\alias{plot_residuals}
\alias{ggplot_residuals}
\title{Residuals plot}
\usage{
plot_residuals(
  fit,
  test,
  type = c("reg", "student", "weight"),
  show_outliers = TRUE,
  show_plot = TRUE,
  ...
)

ggplot_residuals(
  fit,
  test,
  type = c("reg", "student", "weight"),
  show_outliers = TRUE
)
}
\arguments{
\item{fit}{'deconv' class deconvolution object}

\item{test}{bulk gene expression matrix assumed to be in raw counts}

\item{type}{Specifies type of residuals to be plotted}

\item{show_outliers}{Logical whether to show any remaining outlying extreme
genes in red}

\item{show_plot}{Logical whether to show plot using base graphics (used to
allow return of dataframe of points without plotting)}

\item{...}{Optional arguments passed to \code{\link[=plot]{plot()}}}
}
\value{
Produces a scatter plot in base graphics. Returns invisibly a
dataframe of the coordinates of the points. The ggplot version returns a
ggplot2 plotting object.
}
\description{
Plots residuals from a deconvolution result object against bulk gene
expression (on semi-log axis). Normal residuals, weighted residuals or
Studentized residuals can be visualised to check for heteroscedasticity and
genes with extreme errors.
}
