% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.MI.R
\name{CA.MI}
\alias{CA.MI}
\title{Calculate corrected classification accuracy with multiple imputation}
\usage{
CA.MI(fit, what = "EAP", R = 500, n.cores = 1, verbose = TRUE, seed = NULL)
}
\arguments{
\item{fit}{A G-DINA model fit object from the \code{GDINA} package (Ma & de la Torre, 2020).}

\item{what}{What attribute estimates are used? The default is \code{"EAP"}.}

\item{R}{Number of bootstrap samples and imputations. The default is 500.}

\item{n.cores}{Number of processors to use to speed up multiple imputation. The default is 2.}

\item{verbose}{Show progress. The default is \code{TRUE}.}

\item{seed}{A seed for obtaining consistent results. If \code{NULL}, no seed is used. The default is \code{NULL}.}
}
\value{
\code{CA.MI} returns an object of class \code{CA}, with a list of elements:
\describe{
\item{\code{tau}}{Estimated test-level classification accuracy, see Iaconangelo (2017, Eq 2.2) (\code{vector}).}
\item{\code{tau_l}}{Estimated pattern-level classification accuracy, see Iaconangelo (2017, p. 13) (\code{vector}).}
\item{\code{tau_k}}{Estimated attribute-level classification accuracy, see Wang, et al (2015, p. 461 Eq 6) (\code{vector}).}
\item{\code{CCM}}{Conditional classification matrix, see Iaconangelo (2017, p. 13) (\code{matrix}).}
}
}
\description{
This function calculates the test-, pattern-, and attribute-level classification accuracy indices based on integrated posterior probabilities from multiple imputed item parameters (Kreitchmann et al., 2022).
The classification accuracy indices are the ones developed by Iaconangelo (2017) and Wang et al. (2015).
It is only applicable to dichotomous attributes. The function is built upon the \code{CA} function from the \code{GDINA} package (Ma & de la Torre, 2020).
}
\examples{
\donttest{
library(GDINA)
dat <- sim10GDINA$simdat[1:100,]
Q <- sim10GDINA$simQ
fit <- GDINA(dat = dat, Q = Q, model = "GDINA")
ca.mi <- CA.MI(fit)
ca.mi
}
}
\references{
Iaconangelo, C.(2017). \emph{Uses of classification error probabilities in the three-step approach to estimating cognitive diagnosis models}. (Unpublished doctoral dissertation). New Brunswick, NJ: Rutgers University.

Kreitchmann, R. S., de la Torre, J., Sorrel, M. A., Nájera, P., & Abad, F. J. (2022). Improving reliability estimation in cognitive diagnosis modeling. \emph{Behavior Research Methods}. https://doi.org/10.3758/s13428-022-01967-5

Ma, W., & de la Torre, J. (2020). GDINA: An R package for cognitive diagnosis modeling. \emph{Journal of Statistical Software}, \emph{93}(14). https://doi.org/10.18637/jss.v093.i14

Wang, W., Song, L., Chen, P., Meng, Y., & Ding, S. (2015). Attribute-level and pattern-level classification consistency and accuracy indices for cognitive diagnostic assessment. \emph{Journal of Educational Measurement}, emph{52} , 457-476.
}
\author{
{Rodrigo S. Kreitchmann, Universidad Autónoma de Madrid}
}
