% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrDistributions.R
\name{dq}
\alias{dq}
\alias{pq}
\alias{qq}
\alias{rq}
\title{The Famility of Distributions}
\usage{
dq(x, mu, sigma, fd, sd)

rq(n, mu, sigma, fd, sd)

qq(p, mu, sigma, fd, sd)

pq(q, mu, sigma, fd, sd)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{n}{Number of random samples.}

\item{p}{vector of probabilities.}

\item{q}{vector of quantiles.}
}
\value{
\code{dq} gives the density, \code{rq} generates random variates, \code{qq} gives the quantile function, and \code{pq} gives the cumulative densitity of specified distribution.
}
\description{
Density function, distribution function, quantile function, and random generation of variates for a specified cdf-quantile distribution with \code{mean} equal to mean and standard deviation equal to \code{sd}.
}
\examples{
# x <- rq(5, mu = 0.5, sigma = 1, 't2','t2'); x
#[1] 0.3286175 0.7212736 0.6713717 0.2792694 0.3759161

# dq(x, mu = 0.5, sigma = 1, 't2','t2')
# [1]0.6461218 1.3469669 1.2059380 0.6163606 0.6846740

# qtil <- pq(x, mu = 0.5, sigma = 1, 't2','t2');qtil
#[1] 0.2082699 0.5692998 0.5056440 0.1771627 0.2397028

# qq(qtil , mu = 0.5, sigma = 1, 't2','t2')
#[1]   0.3286175 0.7212736 0.6713717 0.2792694 0.3759161
}

