% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{cluster_helix}
\alias{cluster_helix}
\title{cluster_helix}
\usage{
cluster_helix(N = 5, a = 10, b = 10, c = 20, R0 = 100, pitch = 200,
  delta = pi/5, delta0 = 0, right = TRUE, angles = c("helix", "random",
  "fixed"), seed = 123, ...)
}
\arguments{
\item{N}{number of particles}

\item{a}{semi-axis along x}

\item{b}{semi-axis along y}

\item{c}{semi-axis along z}

\item{R0}{radius of helix}

\item{pitch}{pitch of helix}

\item{delta}{angle between particles}

\item{delta0}{initial angle}

\item{right}{logical, helicity}

\item{angles}{type of angular orientation}

\item{seed}{random seed for reproducibility}

\item{...}{extra arguments (ignored)}
}
\value{
list of class cluster with fields: positions, sizes, angles
}
\description{
Particles arranged along a helix
}
\details{
Cluster describing a helical assembly of particles
}
\author{
baptiste Auguie
}
\seealso{
Other user_level cluster: \code{\link{cluster_array}},
  \code{\link{cluster_ball}}, \code{\link{cluster_chain}},
  \code{\link{cluster_dimer}}, \code{\link{cluster_shell}},
  \code{\link{cluster_single}}
}

