% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_cpts.R
\name{preaverage}
\alias{preaverage}
\title{Preaveraging the multivariate time series}
\usage{
preaverage(X, scal = 3)
}
\arguments{
\item{X}{A numerical matrix representing the multivariate time series,
with the columns representing its components.}

\item{scal}{A positive integer number with default value equal to 3. It is
used to define the way we pre-average the data sequences.}
}
\value{
The ``preaveraged'' matrix \eqn{\tilde{X}} of dimensionality
\eqn{Q \times d}, as explained in Details.
}
\description{
This function pre-processes the given data in order to remove serial
correlation that might exist in the given data.
}
\details{
For a given natural number \code{scal} and data matrix \code{X} of
dimensionality \eqn{T \times d}, let us denote by
\eqn{Q = \lceil T/scal \rceil}. Then, \code{\link{preaverage}} calculates,
for all \eqn{j = 1,2, ..., d},
\deqn{\tilde{X}_{q, j} = 1/scal\sum_{t=(q-1) * sc + 1}^{q * sc}X_{t, j},}
for \eqn{q=1, 2, ..., Q-1}, while
\deqn{\tilde{x}_{Q, j} = (T - (Q-1) * sc)^{-1}\sum_{t = (Q-1) * sc + 1}^{T}X_{t, j}.}
}
\examples{
A <- matrix(1:32, 8, 4)
A
A1 <- preaverage(A, scal = 3)
A1
}
\references{
``Cross-covariance isolate detect: a new change-point method
  for estimating dynamic functional connectivity'', Anastasiou et al (2020),
  preprint <doi:10.1101/2020.12.20.423696>.
}
\author{
Andreas Anastasiou, \email{anastasiou.andreas@ucy.ac.cy}
}
