% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_get_catalogs.R
\name{cbs_get_catalogs}
\alias{cbs_get_catalogs}
\title{Retrieves the possible catalog values that can be used for retrieving data}
\usage{
cbs_get_catalogs(..., base_url = BASE_URL)
}
\arguments{
\item{...}{filter statement to select rows, e.g. Language="nl"}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\description{
Retrieves the possible catalog values that can be used for retrieving data
}
\examples{
catalogs <- cbs_get_catalogs()

# Identifier of catalog can be used to query
print(catalogs$Identifier)


ds_rivm <- cbs_get_datasets(catalog = "RIVM")
ds_rivm[1:5, c("Identifier","ShortTitle")]
}
