% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_study.R
\name{get_mutations_by_study}
\alias{get_mutations_by_study}
\title{Get Mutations By Study ID}
\usage{
get_mutations_by_study(
  study_id = NULL,
  molecular_profile_id = NULL,
  add_hugo = TRUE,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{molecular_profile_id}{A string indicating the molecular profile ID from which to pull data. If ID supplied, will
guess the molecular profile ID based on the study ID. Only 1 molecular profile ID can be passed. If mutations from
more than 1 study needed, see \code{sample_study_pairs}}

\item{add_hugo}{Logical indicating whether \code{HugoSymbol} should be added to your results. cBioPortal API does not return this by default (only EntrezId) but this function's default is \code{TRUE} and adds this by default.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of mutations (maf file format)
}
\description{
Get Mutations By Study ID
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_mutations_by_study(study_id = "prad_msk_2019")
get_mutations_by_study(molecular_profile_id = "prad_msk_2019_mutations")

\dontshow{\}) # examplesIf}
}
