% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment_effect.R
\name{estimate_effect}
\alias{estimate_effect}
\title{Estimate treatment effects}
\usage{
estimate_effect(
  causalWeights,
  x = NULL,
  y = NULL,
  model.function,
  estimate.separately = TRUE,
  augment.estimate = FALSE,
  normalize.weights = TRUE,
  ...
)
}
\arguments{
\item{causalWeights}{An object of class \link[=causalWeights-class]{causalWeights}}

\item{x}{A dataHolder, matrix, data.frame, or object of class DataSim. See \link[=calc_weight]{calc_weight} for more details how to input the data. If \code{NULL}, will use the info in the \code{causalWeights} argument.}

\item{y}{The outcome vector.}

\item{model.function}{The modeling function to use, if desired. Must take arguments "formula", "data", and "weights". Other arguments passed via \code{...}, the dots.}

\item{estimate.separately}{Should the outcome model be estimated separately in each treatment group? TRUE or FALSE.}

\item{augment.estimate}{Should an augmented, doubly robust estimator be used?}

\item{normalize.weights}{Should the weights in the \code{causalWeights} argument be normalized to sum to one prior to effect estimation?}

\item{...}{Pass additional arguments to the outcome modeling functions.}
}
\value{
an object of class \link[=causalEffect-class]{causalEffect}
}
\description{
Estimate treatment effects
}
\examples{
if ( torch::torch_is_installed() ){
# set-up data
data <- Hainmueller$new()
data$gen_data()

# calculate quantities
weight <- calc_weight(data, method = "COT", 
                      estimand = "ATT",
                      options = list(lambda = 0))
tx_eff <- estimate_effect(causalWeights = weight)

# get estimate
print(tx_eff@estimate)
all.equal(coef(tx_eff), c(estimate = tx_eff@estimate))
}
}
