% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balanceFunctions.R
\name{entBWOptions}
\alias{entBWOptions}
\title{Options for the Entropy Balancing Weights}
\usage{
entBWOptions(delta = NULL, grid.length = 20L, nboot = 1000L, ...)
}
\arguments{
\item{delta}{A number or vector of tolerances for the balancing functions. Default is NULL which will use a grid search}

\item{grid.length}{The number of values to try in the grid search}

\item{nboot}{The number of bootstrap samples to run during the grid search.}

\item{...}{Arguments passed on to \link[lbfgsb3c:lbfgsb3c]{lbfgsb3c()}}
}
\value{
A list of class \code{entBWOptions} with slots
\itemize{
\item \code{delta} Delta values to try
\item \code{grid.length} The number of parameters to try
\item \code{nboot} Number of bootstrap samples
\item \code{solver.options} A list of options passed to `\link[lbfgsb3c:lbfgsb3c]{lbfgsb3c()}
}
}
\description{
Options for the Entropy Balancing Weights
}
\section{Function balancing}{
This method will balance  functions of the covariates within some tolerance, \eqn{\delta}. For these functions \eqn{B}, we will desire
\deqn{\frac{\sum_{i: Z_i = 0} w_i B(x_i) - \sum_{j: Z_j = 1} B(x_j)/n_1}{\sigma} \leq \delta}, where in this case we are targeting balance with the treatment group for the ATT. \eqn{\sigma} is the pooled standard deviation prior to balancing.
}

\examples{
opts <- entBWOptions(delta = 0.1)
}
