% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cotOOP.R
\name{Measure_}
\alias{Measure_}
\title{An R6 object for measures}
\description{
Internal R6 class object for Measure objects
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{balance_functions}}{the functions of the data that
we want to adjust towards the targets}

\item{\code{balance_target}}{the values the balance_functions are targeting}

\item{\code{adapt}}{What aspect of the data will be adapted. One of "none","weights", or "x".}

\item{\code{device}}{the \code{\link[torch:torch_device]{torch::torch_device()}} of the data.}

\item{\code{dtype}}{the \link[torch:torch_dtype]{torch::torch_dtype} of the data.}

\item{\code{n}}{the rows of the covariates, x.}

\item{\code{d}}{the columns of the covariates, x.}

\item{\code{probability_measure}}{is the measure a probability measure?}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{grad}}{gets or sets gradient}

\item{\code{init_weights}}{returns the initial value of the weights}

\item{\code{init_data}}{returns the initial value of the data}

\item{\code{requires_grad}}{checks or turns on/off gradient}

\item{\code{weights}}{gets or sets weights}

\item{\code{x}}{Gets or sets the data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Measure-detach}{\code{Measure_$detach()}}
\item \href{#method-Measure-get_weight_parameters}{\code{Measure_$get_weight_parameters()}}
\item \href{#method-Measure-print}{\code{Measure_$print()}}
\item \href{#method-Measure-new}{\code{Measure_$new()}}
\item \href{#method-Measure-clone}{\code{Measure_$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-detach"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-detach}{}}}
\subsection{Method \code{detach()}}{
generates a deep clone of the object without gradients.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Measure_$detach()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-get_weight_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-get_weight_parameters}{}}}
\subsection{Method \code{get_weight_parameters()}}{
Makes a copy of the weights parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Measure_$get_weight_parameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-print"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-print}{}}}
\subsection{Method \code{print()}}{
prints the measure object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Measure_$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-new"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-new}{}}}
\subsection{Method \code{new()}}{
Constructor function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Measure_$new(
  x,
  weights = NULL,
  probability.measure = TRUE,
  adapt = c("none", "weights", "x"),
  balance.functions = NA_real_,
  target.values = NA_real_,
  dtype = NULL,
  device = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The data points}

\item{\code{weights}}{The empirical measure. If NULL, assigns equal weight to each observation}

\item{\code{probability.measure}}{Is the empirical measure a probability measure? Default is TRUE.}

\item{\code{adapt}}{Should we try to adapt the data ("x"), the weights ("weights"), or neither ("none"). Default is "none".}

\item{\code{balance.functions}}{A matrix of functions of the covariates to target for mean balance. If NULL and \code{target.values} are provided, will use the data in \code{x}.}

\item{\code{target.values}}{The targets for the balance functions. Should be the same length as columns in \code{balance.functions.}}

\item{\code{dtype}}{The \link[torch:torch_dtype]{torch::torch_dtype} or NULL.}

\item{\code{device}}{The device to have the data on. Should be result of \code{\link[torch:torch_device]{torch::torch_device()}} or NULL.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Measure_$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
